<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSellingUnitQuantityListener.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Product\SellingUnitQuantitiy\Database\Listeners;

use Gambio\Shop\Product\SellingUnitQuantitiy\Quantitiy\Entities\ProductQuantity;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitAvailableQuantityEventInterface;

class OnGetSellingUnitAvailableQuantityListener
{

    /**
     * @param OnGetSellingUnitAvailableQuantityEventInterface $event
     *
     * @return OnGetSellingUnitAvailableQuantityEventInterface
     */
    public function __invoke(OnGetSellingUnitAvailableQuantityEventInterface $event
    ): OnGetSellingUnitAvailableQuantityEventInterface {

        $qty = $event->product()->getProductQuantity();
        $event->addQuantity(new ProductQuantity($qty, $event->product()->measureUnit()));
        $event->stopPropagation();
        return $event;
    }
}